/* 
    elemendid lehelt, mida on vaja:
    .score-counter
    .btn-make
    .btn-buy-machine
    .btn-hire-helper

    muutujad, mida on vaja:
    - totalIceCream 
    - machineIceCreamPerSecond
    - helperMultiplier
    - machinePrice
    - helperPrice
    
*/

/* DEFINEERIME MUUTUJAD */
const scoreCounter = document.querySelector('.score-counter');
const iceCreamBtn = document.querySelector('.btn-make');
const buyMachineBtn = document.querySelector('.btn-buy-machine');
const hireHelperBtn = document.querySelector('.btn-hire-helper');
const machinePriceDisplay = document.querySelector('.machine-price');
const helperPriceDisplay = document.querySelector('.helper-price');

const machinePrice = 100;
const helperPrice = 25;

let totalIceCream = 0;
let machineIceCreamPerSecond = 0;
let helperMultiplier = 0;

/* DEFINEERIME FUNKTSIOONID */
function makeIceCreamOnClick() {
    totalIceCream = totalIceCream + 1 + helperMultiplier;
    scoreCounter.innerHTML = totalIceCream;
}

function hireHelper() {
    if (totalIceCream >= helperPrice) {
        totalIceCream = totalIceCream - helperPrice;
        /* shorter version: totalIceCream -= helperPrice */

        helperMultiplier = helperMultiplier + 1;
        scoreCounter.innerHTML = totalIceCream;
        helperPriceDisplay.innerHTML = helperPrice;
    }
}

function buyMachine() {
    if (totalIceCream >= machinePrice) {
        totalIceCream = totalIceCream - machinePrice;
        /* shorter version: totalIceCream -= helperPrice */

        machineIceCreamPerSecond = machineIceCreamPerSecond + 1;
        scoreCounter.innerHTML = totalIceCream;
        machinePriceDisplay.innerHTML = machinePrice;
    }
}

function makeIceCreamEverySecond() {
    if (machineIceCreamPerSecond > 0) {
        totalIceCream = totalIceCream + machineIceCreamPerSecond;
        scoreCounter.innerHTML = totalIceCream;
    }
}

/* LISAME EVENT LISTENERID */
iceCreamBtn.addEventListener('click', makeIceCreamOnClick);
hireHelperBtn.addEventListener('click', hireHelper);
buyMachineBtn.addEventListener('click', buyMachine);

setInterval(makeIceCreamEverySecond, 1000);